function [fig] = plot_tradeoffs(results)

% This function plots length of exposure against ice thickness during Stage 2
% This is used to make Figure 9. Needs to be done for each core seperately.

% set up figure
fig = figure('units', 'normalized', 'pos',[0.2 0.3 0.5 0.5],'tag','tradeoffs');
axu = axes('pos',[0.1 0.35 0.415 0.6],'Box', 'on'); hold on; % main axes
title(strcat(results.core,' results - lowstand duration Vs. ice thickness'))

axd = axes('pos',[0.1 0.07 0.415 0.2],'Box', 'on'); hold on; % axes for histo of lowstand duration
axl = axes('pos',[0.55 0.35 0.15 0.6], 'Box', 'on');hold on; % axes for histo of ice thickness 
set(axu,'tag','axu');
set(axd,'tag','axd');
set(axl,'tag','axl');

% Length of Stage 2
length_S2 = results.Ts_clip10(:,4) - results.Ts_clip10(:,3); % thin/no ice, spallation production

% Now plot scatter plot of lowstand duration (S2) Vs ice thickness  results have marker size
% scaled in order of fit for top 10% of fitting iterations (remiander are same size)
axes(axu) % define axes

scale_n = length(length_S2) ./ 10; scale_n2 = length(length_S2) - scale_n; % set up scale vector sizes
sz1 = flip(logspace(1.7,3,scale_n)); sz2 = 15 .* ones(1,scale_n2); sz = cat(2,sz1, sz2)'; % creat scale vectors (can change marker size here)

% and plot
scatter(length_S2, results.Zs_clip10(:,4),'filled', 'MarkerEdgeColor', 'k', 'SizeData', sz, 'MarkerFaceAlpha', 0.7, 'MarkerEdgeAlpha', 0.4);

% adjust axes
set(gca,'xlim',[0 8000])
set(gca, 'ylim',[-0.5 8])
xlabel('Duration of exposure (lowstand) [yrs]')
ylabel('Thickness of ice cover (m)')

% plot histogram of lowstand duration
axes(axd)
histogram(length_S2,50)
set(gca,'xlim',[0 8000])
xlabel('Duration of exposure (lowstand) [yrs]')
ylabel('Frequency')

% plot histogram of ice thicknesses
axes(axl)
histogram(results.Zs_clip10(:,4),25,'BinLimits',[0 max(results.Zs_clip10(:,4))])
set(gca,'xlim',[-0.5 8])
ylabel('Frequency')
xlabel('Thickness of ice cover (m)')

% add label for ~zero thickness bin
num0 = num2str(sum(results.Zs_clip10(:,4) == 0,'all')); % get number for label
str = strcat('N =',' ',num0,' ');
annotation('textarrow', [0.6 0.6], [0.5 0.41], 'String', str)
camroll(90) % rotate axes

out = fig;